<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class ItemOrder extends Model 
{

    protected $table = 'item_order';
    public $timestamps = true;
    protected $fillable = array('item_id', 'order_id', 'quantity', 'special_order', 'price');

    public function orders()
    {
        return $this->belongsToMany('App\Models\Order', 'order_id');
    }

    public function items()
    {
        return $this->belongsToMany('App\Models\Item', 'item_id');
    }

}